% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimateGeneAge.R
\name{createGeneAgePlot}
\alias{createGeneAgePlot}
\title{Create gene age plot}
\usage{
createGeneAgePlot(geneAgePlotDf, textFactor = 1, font = "Arial")
}
\arguments{
\item{geneAgePlotDf}{data frame required for plotting gene age (see
?geneAgePlotDf)}

\item{textFactor}{increase factor of text size}

\item{font}{font of text. Default = Arial"}
}
\value{
A gene age distribution plot as a ggplot2 object
}
\description{
Create gene age plot
}
\examples{
geneAgePlotDf <- data.frame(
    name = c("Streptophyta (Phylum)", "Bikonta", "Eukaryota (Superkingdom)"),
    count = c(7, 1, 30),
    percentage = c(18, 3, 79)
)
createGeneAgePlot(geneAgePlotDf, 1, "sans")
}
\seealso{
\code{\link{estimateGeneAge}} and \code{\link{geneAgePlotDf}}
}
\author{
Vinh Tran tran@bio.uni-frankfurt.de
}
