% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/toolBox.R
\name{phosCollapse}
\alias{phosCollapse}
\title{Summarising phosphosites to proteins}
\usage{
phosCollapse(mat, id, stat, by='min')
}
\arguments{
\item{mat}{a matrix with rows correspond to phosphosites and columns
correspond to samples.}

\item{id}{an array indicating the groupping of phosphosites etc.}

\item{stat}{an array containing statistics of phosphosite such as
phosphorylation levels.}

\item{by}{how to summarise phosphosites using their statistics. Either by
'min' (default), 'max', or 'mid'.}
}
\value{
A matrix summarised to protein level
}
\description{
Summarising phosphosite-level information to proteins for performing
downstream gene-centric analyses.
}
\examples{
library(limma)

data('phospho_L6_ratio_pe')
data('SPSs')

grps = gsub('_.+', '', colnames(phospho.L6.ratio.pe))

L6.sites = paste(sapply(GeneSymbol(phospho.L6.ratio.pe), function(x)paste(x)),
                 ";",
                 sapply(Residue(phospho.L6.ratio.pe), function(x)paste(x)),
                 sapply(Site(phospho.L6.ratio.pe), function(x)paste(x)),
                 ";", sep = "")

# Construct a design matrix by condition
design = model.matrix(~ grps - 1)

ctl = which(L6.sites \%in\% SPSs)
phospho.L6.ratio.pe = RUVphospho(phospho.L6.ratio.pe, 
                                  M = design, k = 3, ctl = ctl)

# fit linear model for each phosphosite
f <- grps
X <- model.matrix(~ f - 1)
fit <- lmFit(SummarizedExperiment::assay(phospho.L6.ratio.pe, "normalised"), X)

# extract top-ranked phosphosites for each condition compared to basal
table.AICAR <- topTable(eBayes(fit), number=Inf, coef = 1)
table.Ins <- topTable(eBayes(fit), number=Inf, coef = 3)
table.AICARIns <- topTable(eBayes(fit), number=Inf, coef = 2)

DE1.RUV <- c(sum(table.AICAR[,'adj.P.Val'] < 0.05),
    sum(table.Ins[,'adj.P.Val'] < 0.05),
    sum(table.AICARIns[,'adj.P.Val'] < 0.05))

# extract top-ranked phosphosites for each group comparison
contrast.matrix1 <- makeContrasts(fAICARIns-fIns, levels=X)
contrast.matrix2 <- makeContrasts(fAICARIns-fAICAR, levels=X)
fit1 <- contrasts.fit(fit, contrast.matrix1)
fit2 <- contrasts.fit(fit, contrast.matrix2)
table.AICARInsVSIns <- topTable(eBayes(fit1), number=Inf)
table.AICARInsVSAICAR <- topTable(eBayes(fit2), number=Inf)

DE2.RUV <- c(sum(table.AICARInsVSIns[,'adj.P.Val'] < 0.05),
    sum(table.AICARInsVSAICAR[,'adj.P.Val'] < 0.05))

o <- rownames(table.AICARInsVSIns)
Tc <- cbind(table.Ins[o,'logFC'], table.AICAR[o,'logFC'],
            table.AICARIns[o,'logFC'])
rownames(Tc) = gsub('(.*)(;[A-Z])([0-9]+)(;)', '\\\\1;\\\\3;', o)
colnames(Tc) <- c('Ins', 'AICAR', 'AICAR+Ins')

# summary phosphosite-level information to proteins for performing downstream
# gene-centric analyses.
Tc.gene <- phosCollapse(Tc, id=gsub(';.+', '', rownames(Tc)),
    stat=apply(abs(Tc), 1, max), by = 'max')

}
