% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/toolBox.R
\name{medianScaling}
\alias{medianScaling}
\title{Median centering and scaling}
\usage{
medianScaling(mat, scale = FALSE, grps = NULL, reorder = FALSE, assay = NULL)
}
\arguments{
\item{mat}{a matrix with rows correspond to phosphosites and columns
correspond to samples.}

\item{scale}{a boolean flag indicating whether to scale the samples.}

\item{grps}{a string or factor specifying the grouping (replciates).}

\item{reorder}{To reorder the columns by group (\code{grps}).
By default (\code{reorder=FALSE}), original column order is maintained.}

\item{assay}{an assay to be selected if \code{mat} is a PhosphoExperiment 
object.}
}
\value{
A median scaled matrix
}
\description{
Median centering and scaling of an input numeric matrix
}
\examples{

data('phospho.cells.Ins.sample')
grps = gsub('_[0-9]{1}', '', colnames(phospho.cells.Ins))
phospho.cells.Ins.filtered <- selectGrps(phospho.cells.Ins, grps, 0.5, n=1)

set.seed(123)
phospho.cells.Ins.impute <-
    scImpute(phospho.cells.Ins.filtered,
            0.5,
            grps)[,colnames(phospho.cells.Ins.filtered)]

set.seed(123)
phospho.cells.Ins.impute[,seq(5)] <- ptImpute(
    phospho.cells.Ins.impute[,seq(6,10)],
    phospho.cells.Ins.impute[,seq(5)], percent1 = 0.6,
    percent2 = 0, paired = FALSE)

phospho.cells.Ins.ms <-
    medianScaling(phospho.cells.Ins.impute, scale = FALSE)

}
