% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kinaseSubstratePrediction.R
\name{kinaseSubstrateScore}
\alias{kinaseSubstrateScore}
\title{Kinase substrate scoring}
\usage{
kinaseSubstrateScore(
  substrate.list,
  mat,
  seqs,
  numMotif = 5,
  numSub = 1,
  species = "mouse",
  verbose = TRUE
)
}
\arguments{
\item{substrate.list}{A list of kinases with each element containing an array
of substrates.}

\item{mat}{A matrix with rows correspond to phosphosites and columns
correspond to samples.}

\item{seqs}{An array containing aa sequences surrounding each of all
phosphosites.
Each sequence has length of 15 (-7, p, +7).}

\item{numMotif}{Minimum number of sequences used for compiling motif for
each kinase.
Default is 5.}

\item{numSub}{Minimum number of phosphosites used for compiling
phosphorylation
profile for each kinase. Default is 1.}

\item{species}{Motif list species to be used. Currently there are 
\code{mouse} (default), \code{human} and \code{rat}.}

\item{verbose}{Default to \code{TRUE} to show messages during the progress.
All messages will be suppressed if set to \code{FALSE}}
}
\value{
A list of 4 elements.
\code{motifScoreMatrix}, \code{profileScoreMatrix},
\code{combinedScoreMatrix}, \code{ksActivityMatrix} (kinase activity matrix)
and their \code{weights}.
}
\description{
This function generates substrate scores for kinases that pass
filtering based on both motifs and dynamic profiles
}
\examples{
data('phospho_L6_ratio_pe')
data('SPSs')
data('PhosphoSitePlus')

ppe <- phospho.L6.ratio.pe
sites = paste(sapply(GeneSymbol(ppe), function(x)x),";",
    sapply(Residue(ppe), function(x)x),
    sapply(Site(ppe), function(x)x),
    ";", sep = "")
grps = gsub("_.+", "", colnames(ppe))
design = model.matrix(~ grps - 1)
ctl = which(sites \%in\% SPSs)
ppe = RUVphospho(ppe, M = design, k = 3, ctl = ctl)

phosphoL6 = SummarizedExperiment::assay(ppe, "normalised")

# filter for up-regulated phosphosites
phosphoL6.mean <- meanAbundance(phosphoL6, grps = grps)
aov <- matANOVA(mat=phosphoL6, grps = grps)
idx <- (aov < 0.05) & (rowSums(phosphoL6.mean > 0.5) > 0)
phosphoL6.reg <- phosphoL6[idx, ,drop = FALSE]

L6.phos.std <- standardise(phosphoL6.reg)

rownames(L6.phos.std) <- paste0(GeneSymbol(ppe), ";", Residue(ppe), 
    Site(ppe), ";")[idx]

L6.phos.seq <- Sequence(ppe)[idx]

L6.matrices <- kinaseSubstrateScore(PhosphoSite.mouse, L6.phos.std,
    L6.phos.seq, numMotif = 5, numSub = 1)
}
