% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kinaseSubstratePrediction.R
\name{kinaseSubstrateProfile}
\alias{kinaseSubstrateProfile}
\title{Kinase substrate profiling}
\usage{
kinaseSubstrateProfile(substrate.list, mat)
}
\arguments{
\item{substrate.list}{a list of kinases with each element containing an array
of substrates.}

\item{mat}{a matrix with rows correspond to phosphosites and columns
correspond to samples.}
}
\value{
Kinase profile list.
}
\description{
This function generates substrate profiles for kinases that have
one or more substrates quantified in the phosphoproteome data.
}
\examples{
data('phospho_L6_ratio_pe')
data('SPSs')
data('PhosphoSitePlus')

ppe <- phospho.L6.ratio.pe
sites = paste(sapply(GeneSymbol(ppe), function(x)x),";",
    sapply(Residue(ppe), function(x)x),
    sapply(Site(ppe), function(x)x),
    ";", sep = "")
grps = gsub("_.+", "", colnames(ppe))
design = model.matrix(~ grps - 1)
ctl = which(sites \%in\% SPSs)
ppe = RUVphospho(ppe, M = design, k = 3, ctl = ctl)

phosphoL6 = SummarizedExperiment::assay(ppe, "normalised")

# filter for up-regulated phosphosites
phosphoL6.mean <- meanAbundance(phosphoL6, grps = grps)
aov <- matANOVA(mat=phosphoL6, grps = grps)
idx <- (aov < 0.05) & (rowSums(phosphoL6.mean > 0.5) > 0)
phosphoL6.reg <- phosphoL6[idx, ,drop = FALSE]

L6.phos.std <- standardise(phosphoL6.reg)

ks.profile.list <- kinaseSubstrateProfile(PhosphoSite.mouse, L6.phos.std)
}
