% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kinaseSubstratePrediction.R
\name{kinaseSubstratePred}
\alias{kinaseSubstratePred}
\title{kinaseSubstratePred}
\usage{
kinaseSubstratePred(
    phosScoringMatrices,
    ensembleSize = 10,
    top = 50,
    cs = 0.8,
    inclusion = 20,
    iter = 5,
    verbose = TRUE
)
}
\arguments{
\item{phosScoringMatrices}{An output of kinaseSubstrateScore.}

\item{ensembleSize}{An ensemble size.}

\item{top}{a number to select top kinase substrates.}

\item{cs}{Score threshold.}

\item{inclusion}{A minimal number of substrates required for a kinase to be
selected.}

\item{iter}{A number of iterations for adaSampling.}

\item{verbose}{Default to \code{TRUE} to show messages during the progress.
All messages will be suppressed if set to \code{FALSE}}
}
\value{
Kinase prediction matrix
}
\description{
A machine learning approach for predicting specific kinase for a given
substrate. This prediction framework utilise adaptive sampling.
}
\examples{
data('phospho_L6_ratio_pe')
data('SPSs')
data('PhosphoSitePlus')

ppe <- phospho.L6.ratio.pe
sites = paste(sapply(GeneSymbol(ppe), function(x)x),";",
    sapply(Residue(ppe), function(x)x),
    sapply(Site(ppe), function(x)x),
    ";", sep = "")
grps = gsub("_.+", "", colnames(ppe))
design = model.matrix(~ grps - 1)
ctl = which(sites \%in\% SPSs)
ppe = RUVphospho(ppe, M = design, k = 3, ctl = ctl)

phosphoL6 = SummarizedExperiment::assay(ppe, "normalised")

# filter for up-regulated phosphosites
phosphoL6.mean <- meanAbundance(phosphoL6, grps = grps)
aov <- matANOVA(mat=phosphoL6, grps = grps)
idx <- (aov < 0.05) & (rowSums(phosphoL6.mean > 0.5) > 0)
phosphoL6.reg <- phosphoL6[idx, ,drop = FALSE]

L6.phos.std <- standardise(phosphoL6.reg)

rownames(L6.phos.std) <- paste0(GeneSymbol(ppe), ";", Residue(ppe), 
    Site(ppe), ";")[idx]

L6.phos.seq <- Sequence(ppe)[idx]

L6.matrices <- kinaseSubstrateScore(PhosphoSite.mouse, L6.phos.std,
    L6.phos.seq, numMotif = 5, numSub = 1)
set.seed(1)
L6.predMat <- kinaseSubstratePred(L6.matrices, top=30)
}
