% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotPSig.R
\name{plot.PharmacoSig}
\alias{plot.PharmacoSig}
\title{Plots a PharmacoSig object into a Volcano Plot}
\usage{
\method{plot}{PharmacoSig}(
  x,
  adjust.method,
  drugs,
  features,
  effect_cutoff,
  signif_cutoff,
  color,
  ...
)
}
\arguments{
\item{x}{\code{PharmacoSig} a PharmacoSig object, result of drugSensitivitySig
or drugPerturbationSig}

\item{adjust.method}{\code{character(1)} or \code{logical(1)} either FALSE for no adjustment,
or one of the methods implemented by p.adjust. Defaults to FALSE for no
correction}

\item{drugs}{\code{character} a vector of drug names for which to plot the estimated
associations with gene expression}

\item{features}{\code{character} a vector of features for which to plot the estimated
associations with drug treatment}

\item{effect_cutoff}{the cutoff to use for coloring significant effect sizes.}

\item{signif_cutoff}{the cutoff to use for coloring significance by p value or
adjusted p values. Not on log scale.}

\item{color}{one color if no cutoffs set for plotting. A vector of colors otherwise
used to color points the in three categories above.}

\item{...}{additional arguments, not currently used, but left here for consistency with plot}
}
\value{
returns a ggplot object, which by default will be evaluated and the plot displayed, or
can be saved to a variable for further customization by adding ggplot elements to the returned
graph
}
\description{
Given a PharmacoSig, this will plot a volcano plot, with parameters to set cutoffs
for a significant effect size, p value, to pick multiple testing correction strategy,
and to change point colors. Built on top of ggplot, it will return the plot object which
can be easily customized as any other ggplot.
}
\examples{
data(GDSCsmall)
drug.sensitivity <- drugSensitivitySig(GDSCsmall, mDataType="rna", 
             nthread=1, features = fNames(GDSCsmall, "rna")[1])
plot(drug.sensitivity)

}
