% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{partialCorQUICKSTOP}
\alias{partialCorQUICKSTOP}
\title{QUICKSTOP significance testing for partial correlation}
\usage{
partialCorQUICKSTOP(
  pin_x,
  pin_y,
  pobsCor,
  pGroupFactor,
  pGroupSize,
  pnumGroup,
  pMaxIter,
  pn,
  preq_alpha,
  ptolerance_par,
  plog_decision_boundary,
  pseed
)
}
\arguments{
\item{pin_x}{one of the two vectors to correlate.}

\item{pin_y}{the other vector to calculate}

\item{pobsCor}{the observed (partial) correlation between these varaiables}

\item{pGroupFactor}{an integer vector labeling group membership, to correct
for in the partial correlation. NEEDS TO BE ZERO BASED!}

\item{pGroupSize}{an integer vector of size length(unique(pGroupFactor)), counting
the number of members of each group (basically table(pGroupFactor)) as integer vector}

\item{pnumGroup}{how many groups are there (len(pGroupSize))}

\item{pMaxIter}{maximum number of iterations to do, as a REAL NUMBER}

\item{pn}{length of x and y, as a REAL NUMBER}

\item{preq_alpha}{the required alpha for significance}

\item{ptolerance_par}{the tolerance region for quickstop. Suggested to be 1/100th of req_alpha'}

\item{plog_decision_boundary}{log (base e) of 1/probability of incorrectly calling significance, as
per quickstop paper (used to determine the log-odds)}

\item{pseed}{A numeric vector of length 2, used to seed the internal xoroshiro128+ 1.0
random number generator. Note that currently, these values get modified per call, so pass in a copy
if you wish to keep a seed for running same simulation twice}
}
\value{
a double vector of length 4, entry 1 is either 0, 1 (for TRUE/FALSE) or NA_REAL_ for significance determination
NA_REAL_ is returned when the MaxIter were reached before a decision is made. Usually, this occurs when the real p value is close to, or
falls within the tolerance region of (req_alpha, req_alpha+tolerance_par). Entry 2 is the current p value estimate. entry 3 is the total
number of iterations performed. Entry 4 is the number of time a permuted value was larger in absolute value than the observed cor.
}
\description{
This function will test whether the observed partial correlation is significant
at a level of req_alpha, doing up to MaxIter permutations. Currently, it
supports only grouping by discrete categories when calculating a partial correlation.
Currenlty, only does two sided tests.
}
