% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geneDrugSensitivityPCorr.R
\name{geneDrugSensitivityPCorr}
\alias{geneDrugSensitivityPCorr}
\title{Calculate The Gene Drug Sensitivity}
\usage{
geneDrugSensitivityPCorr(
  x,
  type,
  batch,
  drugpheno,
  test = c("resampling", "analytic"),
  req_alpha = 0.05,
  nBoot = 1000,
  conf.level = 0.95,
  max_perm = getOption("PharmacoGx_Max_Perm", ceiling(1/req_alpha * 100)),
  verbose = FALSE
)
}
\arguments{
\item{x}{A \code{numeric} vector of gene expression values}

\item{type}{A \code{vector} of factors specifying the cell lines or type types}

\item{batch}{A \code{vector} of factors specifying the batch}

\item{drugpheno}{A \code{numeric} vector of drug sensitivity values (e.g.,
IC50 or AUC)}

\item{test}{A \code{character} string indicating whether resampling or analytic based tests should be used}

\item{req_alpha}{\code{numeric}, number of permutations for p value calculation}

\item{nBoot}{\code{numeric}, number of bootstrap resamplings for confidence interval estimation}

\item{conf.level}{\code{numeric}, between 0 and 1. Size of the confidence interval required}

\item{max_perm}{\code{numeric} the maximum number of permutations that QUICKSTOP can do before giving up and returning NA.
Can be set globally by setting the option "PharmacoGx_Max_Perm", or left at the default of \code{ceiling(1/req_alpha*100)}.}

\item{verbose}{\code{boolean} Should the function display messages?}
}
\value{
A \code{vector} reporting the effect size (estimateof the coefficient
of drug concentration), standard error (se), sample size (n), t statistic,
and F statistics and its corresponding p-value.
}
\description{
This version of the function uses a partial correlation instead of standardized linear models.
}
\examples{
print("TODO::")

}
