% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PharmacoSet-class.R
\name{PharmacoSet2}
\alias{PharmacoSet2}
\title{Make a CoreSet with the updated class structure}
\usage{
PharmacoSet2(
  name = "emptySet",
  treatment = data.frame(),
  sample = data.frame(),
  molecularProfiles = MultiAssayExperiment(),
  treatmentResponse = TreatmentResponseExperiment(),
  perturbation = list(),
  curation = list(sample = data.frame(), treatment = data.frame(), tissue = data.frame()),
  datasetType = "sensitivity"
)
}
\arguments{
\item{name}{A \code{character(1)} vector with the \code{PharmacoSet} objects name.}

\item{treatment}{A \code{data.frame} with treatment level metadata. Treatments in a \code{PharmacoSet} represent pharmaceutical compounds.}

\item{sample}{A \code{data.frame} with sample level metadata for the union
of samples in \code{treatmentResponse} and \code{molecularProfiles}. Samples in a \code{PharmacoSet} represent cancer cell-lines.}

\item{molecularProfiles}{A \code{MultiAssayExperiment} containing one
\code{SummarizedExperiment} object for each molecular data type.}

\item{treatmentResponse}{A \code{LongTable} or \code{LongTableDataMapper} object
containing all treatment response data associated with the \code{PharmacoSet}
object.}

\item{perturbation}{A deprecated slot in a \code{PharmacoSet} object included
for backwards compatibility. This may be removed in future releases.}

\item{curation}{This class requires an additional curation item, tissue, which maps
from published to standardized tissue idenifiers.}

\item{datasetType}{A deprecated slot in a \code{PharmacoSet} object included
for backwards compatibility. This may be removed in future releases.}
}
\value{
A \code{CoreSet} object storing standardized and curated treatment
response and multiomic profile data associated with a given publication.
}
\description{
New implementation of the CoreSet constructor to support MAE and TRE. This
constructor will be swapped with the original \code{CoreSet} constructor as
part of an overhaul of the CoreSet class structure.
}
\examples{
data(CCLEsmall)
CCLEsmall

}
