% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PhIPData-class.R
\name{PhIPData-methods}
\alias{PhIPData-methods}
\alias{counts,PhIPData-method}
\alias{logfc}
\alias{logfc,PhIPData-method}
\alias{prob}
\alias{prob,PhIPData-method}
\alias{peptideInfo}
\alias{peptideInfo,PhIPData-method}
\alias{sampleInfo}
\alias{sampleInfo,PhIPData-method}
\alias{assays<-,PhIPData,list-method}
\alias{assays<-,PhIPData,SimpleList-method}
\alias{assay<-,PhIPData,missing-method}
\alias{assay<-,PhIPData,numeric-method}
\alias{assay<-,PhIPData,character-method}
\alias{counts<-,PhIPData-method}
\alias{logfc<-}
\alias{logfc<-,PhIPData-method}
\alias{prob<-}
\alias{prob<-,PhIPData-method}
\alias{peptideInfo<-}
\alias{peptideInfo<-,PhIPData-method}
\alias{sampleInfo<-}
\alias{sampleInfo<-,PhIPData-method}
\title{Accessing and Modifying Information in PhIPData objects}
\usage{
\S4method{counts}{PhIPData}(object, ...)

logfc(object, ...)

\S4method{logfc}{PhIPData}(object, ...)

prob(object, ...)

\S4method{prob}{PhIPData}(object, ...)

peptideInfo(object, ...)

\S4method{peptideInfo}{PhIPData}(object, ...)

sampleInfo(object, ...)

\S4method{sampleInfo}{PhIPData}(object, ...)

\S4method{assays}{PhIPData,list}(x, withDimnames = TRUE, ...) <- value

\S4method{assays}{PhIPData,SimpleList}(x, withDimnames = TRUE, ...) <- value

\S4method{assay}{PhIPData,missing}(x, i, withDimnames = TRUE, ...) <- value

\S4method{assay}{PhIPData,numeric}(x, i, withDimnames = TRUE, ...) <- value

\S4method{assay}{PhIPData,character}(x, i, withDimnames = TRUE, ...) <- value

\S4method{counts}{PhIPData}(object, ...) <- value

logfc(object, ...) <- value

\S4method{logfc}{PhIPData}(object, ...) <- value

prob(object, ...) <- value

\S4method{prob}{PhIPData}(object, ...) <- value

peptideInfo(object) <- value

\S4method{peptideInfo}{PhIPData}(object) <- value

sampleInfo(object, ...) <- value

\S4method{sampleInfo}{PhIPData}(object) <- value
}
\arguments{
\item{object}{A \code{PhIPData} object}

\item{...}{parameters for \code{\link[SummarizedExperiment]{assays}},
which are typically not needed.}

\item{x}{A \code{PhIPData} object}

\item{withDimnames}{Parameter for
\linkS4class{RangedSummarizedExperiment} class functions. Overrided
since row/column names are automatically synced within each object.}

\item{value}{A \code{matrix}, \code{data.frame}, or \linkS4class{DataFrame}
of the same dimensions (not necessarily the same names)}

\item{i}{A \code{numeric}, {character}}
}
\value{
Accessors: a \link{DataFrame} object

Setters: a \code{PhIPData} object
}
\description{
Methods to extract and modify \code{assay(s)}(including
convenient functions for \code{counts}, \code{logfc}, and \code{prob}),
\code{sampleInfo}, \code{peptideInfo}, and \code{metadata}.
}
\details{
In addition to the functions detailed in
\linkS4class{RangedSummarizedExperiment}, the \code{PhIPData} class includes
conveniently named functions to quickly access and modify frequently used
components of PhIPData objects.

Replacement functions ensure that names of the replacement object are matched
with the names of the \code{PhIPData} object.

Since packages for identifying differential expression in RNA-seq experiments
are frequently used for estimating fold-changes for peptide enrichments,
the class also includes coercion methods to and from \linkS4class{DGEList}s.
}
\section{Available methods}{

In the following code snippets, \code{x} is a \linkS4class{PhIPData} object,
\code{value} is a matrix-like object with the same dimensions as \code{x},
and \code{...} are further arguments passed to \code{\link{assay}}
(for the getter) or \code{\link{assay<-}} (for the setter).
\describe{
\item{\code{counts(x, ...)}, \code{counts(x, ...) <- value}:}{
Get or set a matrix of raw read counts
}
\item{\code{logfc(x, ...)}, \code{logfc(x, ...) <- value}:}{
Get or set a matrix of log2 estimated fold changes (in comparison to
beads-only samples)
}
\item{\code{prob(x, ...)}, \code{pob(x, ...) <- value}:}{
Get or set a matrix of probabilities associated with whether
         a sample has an enriched antibody response for a peptide.
}
}
}

\examples{
example("PhIPData")

replacement_dat <- matrix(1L, nrow = 5, ncol = 5)

## SummarizedExperiment Accessors and Setters
assays(phip_obj)
assays(phip_obj)$counts <- replacement_dat
assay(phip_obj, "logfc")
assay(phip_obj, "logfc") <- replacement_dat

## counts
counts(phip_obj)
counts(phip_obj) <- counts_dat

## logfc
logfc(phip_obj)
logfc(phip_obj) <- logfc_dat

## prob
prob(phip_obj)
prob(phip_obj) <- replacement_dat

## coercion functions
as(phip_obj, "DGEList")
as(phip_obj, "List")
as(phip_obj, "list")
}
\seealso{
\code{\link[SummarizedExperiment]{assays}} for
\linkS4class{SummarizedExperiment} operations.
}
