% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FitLmerBySample.R
\name{FitLmerBySample}
\alias{FitLmerBySample}
\title{Fit a linear mixed model}
\usage{
FitLmerBySample(y, design)
}
\arguments{
\item{y}{a matrix of log2-transformed peptide abundance for one protein}

\item{design}{design matrix}
}
\value{
\code{FitLmerBySample} returns the estimated inter-peptide correlation coefficient.
}
\description{
Fit a linear mixed model to the abundance of peptides belonging to one protein
and compute the correlation coefficient based on variance components. Sample is
treated as a random effect in the mixed model.
}
\examples{
y <- matrix(rnorm(1000*6), 1000, 6)
design <- cbind(Intercept = 1, Group = c(0, 0, 0, 1, 1, 1))

FitLmerBySample(y, design)

}
\author{
Junmin Wang and Steven Novick
}
