% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EstimInterPepCor.R
\name{EstimInterPepCor}
\alias{EstimInterPepCor}
\title{Estimation of inter-peptide correlation}
\usage{
EstimInterPepCor(
  dat,
  design,
  pep_mapping_tbl,
  equal.correlation = FALSE,
  logged = FALSE
)
}
\arguments{
\item{dat}{a dataframe or matrix of peptide abundance, or a SummarizedExperiment object where
grouping and peptide-protein mapping are provided in colData and rowData, respectively.}

\item{design}{design matrix}

\item{pep_mapping_tbl}{a table mapping peptides to proteins. Alternatively, it can be the
column name of the protein in rowData if dat is a SummarizedExperiment object.}

\item{equal.correlation}{Boolean variable indicating whether all pairwise
inter-peptide correlation coefficients are assumed to be equal within a protein.
If true, the mixed model approach will be applied; otherwise, the approach
described in Wu and Smyth (2012), \emph{Nucleic Acids Research} will be applied.
In either case, only non-negative mean correlations are allowed.}

\item{logged}{Boolean variable indicating whether abundance data have been
log-transformed}
}
\value{
\code{EstimInterPepCor} returns a numeric vector of inter-peptide
correlation coefficients (one value for each protein).
}
\description{
Given peptide abundance and assignment of peptide sequences to proteins,
estimate inter-peptide correlation coefficient for each protein via the
mixed model approach or approach described in Wu and Smyth (2012), \emph{Nucleic Acids Research}.
}
\examples{
# Generate random peptide data
dat <- 2^matrix(rnorm(540), ncol = 6)
colnames(dat) <- paste0("Sample", 1:6)
rownames(dat) <- paste0("Peptide", 1:90)

# Generate peptide mapping table
pep_mapping_tbl <- data.frame(peptide = paste0("Peptide", 1:90),
protein = paste0("Protein", rep(1:30, each = 3)))

# Generate design matrix
group <- c(rep("A", 3), rep("B", 3))
group <- factor(group)
design <- stats::model.matrix(~ 0 + group)

EstimInterPepCor(dat, design, pep_mapping_tbl,
equal.correlation = TRUE, logged = FALSE)

}
\references{
Wu, D, and Smyth, GK (2012). Camera: a competitive gene set test accounting for inter-gene correlation. \emph{Nucleic Acids Research} 40, e133
}
\author{
Junmin Wang and Steven Novick
}
