% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CompPepSetTest.R
\name{CompPepSetTest}
\alias{CompPepSetTest}
\title{Competitive peptide set test}
\usage{
CompPepSetTest(
  result,
  pep_mapping_tbl,
  stat = c("t", "logFC"),
  cor_coef = 0,
  pepC.estim = c("sd", "mad")
)
}
\arguments{
\item{result}{output from \code{EnframeContrastsRes}}

\item{pep_mapping_tbl}{a table mapping peptides to proteins. Alternatively, it can be the
column name of the protein in rowData if dat is a SummarizedExperiment object.}

\item{stat}{statistics to be used in the peptide set test.
Options include "t" (t-statistic) and "logFC" (log2 fold change).}

\item{cor_coef}{inter-peptide correlation coefficient(s)}

\item{pepC.estim}{estimator of the variance of peptide-wise t-statistics not
belonging to the protein of interest, i.e., test set. Options include "sd" and "mad".
"sd" represents sample standard deviation. "mad" represents sample median
absolute deviation.}
}
\value{
\code{CompPepSetTest} returns a dataframe containing the following columns
\item{protein}{unique protein identifier}
\item{NPeps}{number of peptides}
\item{Correlation}{inter-peptide correlation coefficient}
\item{Direction}{direction of change}
\item{PValue}{raw p-value}
\item{adj.P.Val}{p-value adjusted via the Benjamini-Hochberg method}
\item{logFC}{average log2 fold change of peptides}
\item{Up}{number of upregulated peptides}
\item{Down}{number of downregulated peptides}
}
\description{
Given peptide-wise t-statistics and assignment of peptides to proteins,
conduct peptide set tests to assess differential protein expression.
}
\examples{
# Generate random peptide data
dat <- 2^matrix(rnorm(3000), ncol = 6)
colnames(dat) <- paste0("Sample", 1:6)
rownames(dat) <- paste0("Peptide", 1:500)

# Generate peptide mapping table
pep_mapping_tbl <- data.frame(peptide = paste0("Peptide", 1:500),
protein = paste0("Protein", rep(1:100, each = 5)))

# Generate groups and contrasts
group <- c(rep("A", 3), rep("B", 3))
contrasts.par <- "B-A"

fit.cont <- FitContrasts(dat, contrasts.par, group)
cont.res <- EnframeContrastsRes(fit.cont)

# Run peptide set test based on t-statistics and standard deviation
CompPepSetTest(cont.res, pep_mapping_tbl, stat = "t",
cor_coef = 0, pepC.estim = "sd")

# Run peptide set test based on log2 fold change and median absolute deviation
CompPepSetTest(cont.res, pep_mapping_tbl, stat = "logFC",
cor_coef = 0, pepC.estim = "mad")

}
\author{
Junmin Wang
}
