% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/useful_inds.R
\name{useful_inds}
\alias{useful_inds}
\alias{useful_inds,character-method}
\alias{useful_inds,Pedigree-method}
\alias{useful_inds,Ped-method}
\title{Usefulness of individuals}
\usage{
\S4method{useful_inds}{character}(
  obj,
  dadid,
  momid,
  avail,
  affected,
  num_child_tot,
  id_inf,
  keep_infos = FALSE
)

\S4method{useful_inds}{Pedigree}(obj, keep_infos = FALSE, reset = FALSE, max_dist = NULL)

\S4method{useful_inds}{Ped}(obj, keep_infos = FALSE, reset = FALSE, max_dist = NULL)
}
\arguments{
\item{obj}{A character vector with the id of the individuals or a
\code{data.frame} with all the informations in corresponding columns.}

\item{dadid}{A vector containing for each subject, the identifiers of the
biologicals fathers.}

\item{momid}{A vector containing for each subject, the identifiers of the
biologicals mothers.}

\item{avail}{A logical vector with the availability status of the
individuals
(i.e. \code{FALSE} = not available,
\code{TRUE} = available,
\code{NA} = unknown).}

\item{affected}{A logical vector with the affection status of the
individuals
(i.e. \code{FALSE} = unaffected,
\code{TRUE} = affected,
\code{NA} = unknown).}

\item{num_child_tot}{A numeric vector of the number of children of each
individuals}

\item{id_inf}{An identifiers vector of informative individuals.}

\item{keep_infos}{Boolean to indicate if parents with unknown status
but available or reverse should be kept}

\item{reset}{Boolean to indicate if the \code{useful} column should be reset}

\item{max_dist}{The maximum distance to informative individuals}
}
\value{
\subsection{When obj is a vector}{

A vector of useful individuals identifiers
}

\subsection{When obj is a Pedigree or Ped object}{

The Pedigree or Ped object with the slot 'useful' containing \code{TRUE} for
useful individuals and \code{FALSE} otherwise.
}
}
\description{
Compute the usefulness of individuals
}
\details{
Check for the informativeness of the individuals based on the
informative parameter given, the number of children and the usefulness
of their parents. A \code{useful} slot is added to the Ped object with the
usefulness of the individual.
}
\examples{

data(sampleped)
ped1 <- Pedigree(sampleped[sampleped$famid == "1",])
ped1 <- is_informative(ped1, informative = "AvAf", col_aff = "affection")
ped(useful_inds(ped1))
}
\keyword{shrink}
