% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shrink.R
\name{shrink}
\alias{shrink}
\alias{shrink,Pedigree-method}
\alias{shrink,Ped-method}
\title{Shrink Pedigree object}
\usage{
\S4method{shrink}{Pedigree}(obj, avail = NULL, affected = NULL, max_bits = 16)

\S4method{shrink}{Ped}(obj, avail = NULL, affected = NULL, max_bits = 16)
}
\arguments{
\item{obj}{A Pedigree or Ped object.}

\item{avail}{A logical vector with the availability status of the
individuals
(i.e. \code{FALSE} = not available,
\code{TRUE} = available,
\code{NA} = unknown).}

\item{affected}{A logical vector with the affection status of the
individuals
(i.e. \code{FALSE} = unaffected,
\code{TRUE} = affected,
\code{NA} = unknown).}

\item{max_bits}{Optional, the bit size for which to shrink the Pedigree}
}
\value{
A list containing the following elements:
\itemize{
\item pedObj: Pedigree object after trimming
\item id_trim: Vector of ids trimmed from Pedigree
\item id_lst: List of ids trimmed by category
\item bit_size: Vector of bit sizes after each trimming step
\item avail: Vector of availability status after trimming
\item pedSizeOriginal: Number of subjects in original Pedigree
\item pedSizeIntermed: Number of subjects after initial trimming
\item pedSizeFinal: Number of subjects after final trimming
}
}
\description{
Shrink Pedigree object to specified bit size with priority placed on
trimming uninformative subjects. The algorithm is useful for getting a
Pedigree condensed to a minimally informative size for algorithms or testing
that are limited by size of the Pedigree.

If \strong{avail} or \strong{affected} are \code{NULL}, they are extracted
with their corresponding accessors from the Ped object.
}
\details{
Iteratively remove subjects from the Pedigree. The random removal of members
was previously controlled by a seed argument, but we remove this, forcing
users to control randomness outside the function. First remove uninformative
subjects, i.e., unavailable (not genotyped) with no available descendants.
Next, available terminal subjects with unknown phenotype if both parents
available. Last, iteratively shrinks Pedigrees by preferentially removing
individuals (chosen at random if there are multiple of the same status):
\enumerate{
\item Subjects with unknown affected status
\item Subjects with unaffected affected status
\item Affected subjects.
}
}
\examples{
data(sampleped)
ped1 <- Pedigree(sampleped[sampleped$famid == '1',])
shrink(ped1, max_bits = 12)

}
\seealso{
\code{\link[=Pedigree]{Pedigree()}}, \code{\link[=bit_size]{bit_size()}}
}
\author{
Original by Dan Schaid,
updated by Jason Sinnwell and Louis Le Nezet
}
\keyword{shrink}
