% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{sex_to_factor}
\alias{sex_to_factor}
\title{Gender variable to ordered factor}
\usage{
sex_to_factor(sex)
}
\arguments{
\item{sex}{A character, factor or numeric vector corresponding to
the gender of the individuals. This will be transformed to an ordered factor
with the following levels:
\code{male} < \code{female} < \code{unknown}

The following values are recognized:
\itemize{
\item "male": "m", "male", "man", \code{1}
\item "female": "f", "female", "woman", \code{2}
\item "unknown": "unknown", \code{3}
}}
}
\value{
an ordered factor vector containing the transformed variable
"male" < "female" < "unknown"
}
\description{
Gender variable to ordered factor
}
\examples{
sex_to_factor(c(1, 2, 3, "f", "m", "man", "female"))
}
\keyword{internal}
