% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{rescale}
\alias{rescale}
\title{Rescale continuous vector to have specified minimum and maximum}
\usage{
rescale(x, to = c(0, 1), from = range(x, na.rm = TRUE, finite = TRUE))
}
\arguments{
\item{x}{continuous vector of values to manipulate.}

\item{to}{output range (numeric vector of length two)}

\item{from}{input range (vector of length two).  If not given, is
calculated from the range of \code{x}}
}
\value{
A numeric vector of the same length as \code{x} with values
rescaled to the range specified by \code{to}.
}
\description{
Rescale continuous vector to have specified minimum and maximum
}
\details{
Objects of class \verb{<AsIs>} are returned unaltered.
}
\examples{
rescale(1:100)
rescale(runif(50))
rescale(1)
}
\keyword{internal}
