% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/app_data_import.R
\name{read_data}
\alias{read_data}
\title{Read data from file path}
\usage{
read_data(
  file,
  sep = ";",
  quote = "'",
  header = TRUE,
  df_name = NA,
  strings_as_factors = FALSE,
  to_char = TRUE,
  na_values = c("", "NA", "NULL", "None")
)
}
\arguments{
\item{file}{The file path}

\item{sep}{A string defining the separator to use for the file}

\item{quote}{A string defining the quote to use}

\item{header}{A boolean defining if the dataframe contain a header or not}

\item{df_name}{A string defining the name of the dataframe / sheet to use}

\item{strings_as_factors}{A boolean defining if all the strings should be
interpreted ad factor}

\item{to_char}{A boolean defining if all the dataset should be read as
character.}
}
\value{
A dataframe.
}
\description{
Read dataframe based on the extension of the file
}
\details{
This function detect the extension of the file and proceed to use
the according function to read it with the parameters given by the user.
}
\examples{
\dontrun{
    read_data('path/to/my/file.txt', sep=',', header=FALSE)
}
}
\keyword{data_import,}
\keyword{internal}
