% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{plink_to_pedigree}
\alias{plink_to_pedigree}
\title{Import from .fam file or .ped file}
\usage{
plink_to_pedigree(
  path,
  sep = "\\t",
  quote = "'",
  header = FALSE,
  na_values = c("NA", "0")
)
}
\arguments{
\item{path}{Path to the file}

\item{sep}{Separator used in the file}

\item{quote}{Quote used in the file}

\item{header}{Boolean defining if the file has a header}

\item{na_values}{A vector of strings that should be considered as NA}
}
\value{
A Pedigree object
}
\description{
Import a .fam or .ped file and return a Pedigree object
}
\examples{
if (interactive()) {
    write.table(
        data.frame(
            famid = c("1", "1", "1"),
            id = c("A", "B", "C"),
            dadid = c(0, 0, "A"),
            momid = c(0, 0, "B"),
            sex = c(1, 2, 1)
        ), file = "test.fam", sep = "\t", quote = FALSE,
        row.names = FALSE, col.names = FALSE
    )
    fam <- "test.fam"
    pedi <- plink_to_pedigree(fam)
}
}
