% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/norm_data.R
\name{norm_rel}
\alias{norm_rel}
\title{Normalise a Rel object dataframe}
\usage{
norm_rel(
  rel_df,
  multi_code = "error",
  na_strings = c("NA", ""),
  missid = c(NA_character_, "0")
)
}
\arguments{
\item{rel_df}{A data.frame with the special relationships between
individuals. See \code{\link[=Rel]{Rel()}} for more informations.
The minimum columns required are \code{id1}, \code{id2} and \code{code}.
The \code{famid} column can also be used to specify the family
of the individuals.
If a matrix is given, the columns needs to be ordered as
\code{id1}, \code{id2}, \code{code} and \code{famid}.
The code values are:
\itemize{
\item \code{1} = Monozygotic twin
\item \code{2} = Dizygotic twin
\item \code{3} = twin of unknown zygosity
\item \code{4} = Spouse
}

The value relation code recognized by the function are the one defined
by the \code{\link[=rel_code_to_factor]{rel_code_to_factor()}} function.}

\item{multi_code}{How to handle multiple relationship codes in the same group
If "error", an error is thrown. If "warn", a warning is thrown and the
relationship code is set to twins of unknow zigosity. Default is "error".}

\item{na_strings}{Vector of strings to be considered as NA values.}

\item{missid}{A character vector with the missing values identifiers.
All the id, dadid and momid corresponding to those values will be set
to \code{NA_character_}.}
}
\value{
A dataframe with the errors identified
}
\description{
Normalise a dataframe and check for columns correspondance
to be able to use it as an input to create a Ped object.
}
\details{
The \code{famid} column, if provided, will be merged to the
\emph{ids} field separated by an underscore using the
\code{\link[=upd_famid]{upd_famid()}} function.
The \code{code} column will be transformed with the
\code{\link[=rel_code_to_factor]{rel_code_to_factor()}}.
Missing relationship for set of twins will be completed
using \code{\link[=complete_twins]{complete_twins()}}.
Multiple test are done and errors are checked.

A number of checks are done to ensure the dataframe is correct:
\subsection{On identifiers:}{
\itemize{
\item All ids (id1, id2) are not empty (\verb{!= ""})
\item \code{id1} and \code{id2} are not the same
}
}

\subsection{On code}{
\itemize{
\item All code are recognised as either "MZ twin", "DZ twin", "UZ twin" or
"Spouse"
}
}
}
\examples{
df <- data.frame(
    id1 = c(1, 2, 3, 4, 5, 6, 7, 8, 9, 10),
    id2 = c(2, 3, 4, 5, 6, 7, 8, 9, 10, 1),
    code = c("MZ twin", "DZ twin", "UZ twin", "Spouse",
        1, 2, 3, 4, "MzTwin", "sp oUse"),
    famid = c(1, 1, 1, 1, 1, 1, 1, 2, 2, 2)
)
norm_rel(df)

}
