% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_unavailable.R
\name{find_unavailable}
\alias{find_unavailable}
\alias{find_unavailable,Ped-method}
\alias{find_unavailable,Pedigree-method}
\title{Find unavailable subjects in a Pedigree}
\usage{
\S4method{find_unavailable}{Ped}(obj, avail = NULL)

\S4method{find_unavailable}{Pedigree}(obj, avail = NULL)
}
\arguments{
\item{obj}{A Ped or Pedigree object.}

\item{avail}{A logical vector with the availability status of the
individuals
(i.e. \code{FALSE} = not available,
\code{TRUE} = available,
\code{NA} = unknown).}
}
\value{
Returns a vector of subject ids for who can be
removed.
}
\description{
Find the identifiers of subjects in a Pedigree iteratively,
as anyone who is not available and does not have an available
descendant by successively removing unavailable terminal nodes.
}
\details{
If \strong{avail} is null, then the function will use the
corresponding Ped accessor.

Originally written as pedTrim by Steve Iturria, modified by Dan Schaid 2007,
and now split into the two separate functions:
\code{find_unavailable()}, and \code{trim()} to do the tasks separately.
\code{find_unavailable()} calls
\code{\link[=exclude_stray_marryin]{exclude_stray_marryin()}}
to find stray available marry-ins who are
isolated after trimming their unavailable offspring, and
\code{\link[=exclude_unavail_founders]{exclude_unavail_founders()}}.
If the subject ids are character, make sure none of the characters in the
ids is a colon (":"), which is a special character
used to concatenate and split subjects within the utility.
The \code{trim()} functions is now replaced by the \code{subset()} function.
}
\section{Side Effects}{

Relation matrix from subsetting is trimmed of any
special relations that include the subjects to trim.
}

\examples{
data(sampleped)
ped1 <- Pedigree(sampleped[sampleped$famid == "1",])
find_unavailable(ped1)

}
\seealso{
\code{\link[=shrink]{shrink()}}
}
\keyword{internal,}
\keyword{shrink}
