% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_unavailable.R
\name{exclude_unavail_founders}
\alias{exclude_unavail_founders}
\title{Exclude unavailable founders}
\usage{
exclude_unavail_founders(id, dadid, momid, avail, missid = NA_character_)
}
\arguments{
\item{id}{A character vector with the identifiers of each individuals}

\item{dadid}{A vector containing for each subject, the identifiers of the
biologicals fathers.}

\item{momid}{A vector containing for each subject, the identifiers of the
biologicals mothers.}

\item{avail}{A logical vector with the availability status of the
individuals
(i.e. \code{FALSE} = not available,
\code{TRUE} = available,
\code{NA} = unknown).}

\item{missid}{A character vector with the missing values identifiers.
All the id, dadid and momid corresponding to those values will be set
to \code{NA_character_}.}
}
\value{
Returns a list with the following components:
\itemize{
\item n_trimmed Number of trimmed individuals
\item id_trimmed Vector of IDs of trimmed individuals
\item id Vector of subject identifiers
\item dadid Vector of father identifiers
\item momid Vector of mother identifiers
}
}
\description{
Exclude any unavailable founders.
}
\seealso{
\code{\link[=shrink]{shrink()}}
}
\keyword{internal}
\keyword{shrink}
