% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/descendants.R
\name{descendants}
\alias{descendants}
\alias{descendants,character_OR_integer,character_OR_integer-method}
\alias{descendants,character_OR_integer,Pedigree-method}
\alias{descendants,character_OR_integer,Ped-method}
\title{Descendants of individuals}
\usage{
\S4method{descendants}{character_OR_integer,character_OR_integer}(idlist, obj, dadid, momid)

\S4method{descendants}{character_OR_integer,Pedigree}(idlist, obj)

\S4method{descendants}{character_OR_integer,Ped}(idlist, obj)
}
\arguments{
\item{idlist}{List of individuals identifiers to be considered}

\item{obj}{A Ped or Pedigree object or a vector of the
individuals identifiers.}

\item{dadid}{A vector containing for each subject, the identifiers of the
biologicals fathers.}

\item{momid}{A vector containing for each subject, the identifiers of the
biologicals mothers.}
}
\value{
Vector of all descendants of the individuals in idlist.
The list is not ordered.
}
\description{
Find all the descendants of a particular list of individuals
given a Pedigree object.
}
\examples{
data("sampleped")
pedi <- Pedigree(sampleped)
descendants(c("1_101", "2_208"), pedi)
}
\keyword{internal}
