% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/app_data_download.R
\name{data_download_ui}
\alias{data_download_ui}
\alias{data_download_server}
\alias{data_download_demo}
\title{Shiny modules to download a dataframe}
\usage{
data_download_ui(id)

data_download_server(
  id,
  df,
  filename,
  label = NULL,
  helper = TRUE,
  title = "Data download"
)

data_download_demo()
}
\arguments{
\item{id}{A string to identify the module.}

\item{df}{A reactive dataframe.}

\item{filename}{A string to name the file.}

\item{label}{A string to display in the download button.}

\item{helper}{A boolean to display a helper message.}
}
\value{
A shiny module to export a dataframe.
}
\description{
This function allows to download a dataframe as a csv file.
This generate a Shiny module that can be used in a Shiny app.
The function is composed of two parts: the UI and the server.
The UI is called with the function \code{data_download_ui()} and the server
with the function \code{data_download_server()}.
}
\examples{
if (interactive()) {
    data_download_demo()
}
}
\keyword{internal}
