% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{create_text_column}
\alias{create_text_column}
\title{Create a text column}
\usage{
create_text_column(df, title = NULL, cols = NULL, na_strings = c("", "NA"))
}
\arguments{
\item{df}{A dataframe}

\item{title}{The title of the text column}

\item{cols}{A vector of columns to concatenate}

\item{na_strings}{A vector of strings that should be considered as NA}
}
\value{
The concatenated text column
}
\description{
Aggregate multiple columns into a single text column
separated by a newline character.
}
\examples{
df <- data.frame(a = seq_len(3), b = c("4", "NA", 6), c = c("", "A", 2))
Pedixplorer:::create_text_column(df, "a", c("b", "c"))
}
\keyword{internal}
