% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/best_hint.R
\name{best_hint}
\alias{best_hint}
\alias{best_hint,Pedigree-method}
\title{Best hint for a Pedigree alignment}
\usage{
\S4method{best_hint}{Pedigree}(
  obj,
  wt = c(1000, 10, 1),
  tolerance = 0,
  align_parents = TRUE,
  force = FALSE,
  timeout = 60
)
}
\arguments{
\item{obj}{A Pedigree object}

\item{wt}{A vector of three weights for the three error measures.
Default is \code{c(1000, 10, 1)}.
\enumerate{
\item The number of duplicate individuals in the plot
\item The sum of the absolute values of the differences in the
positions of duplicate individuals
\item The sum of the absolute values of the differences between
the center of the children and the parents.
}}

\item{tolerance}{The maximum stress level to accept.
Default is \code{0}}

\item{align_parents}{If \code{align_parents = TRUE}, go one step further
and try to make both parents of each child have the same depth.
(This is not always possible).
It helps the drawing program by lining up pedigrees that
'join in the middle' via a marriage.}

\item{force}{If \code{force = TRUE}, the function will return the depth minus
\code{min(depth)} if \code{depth} reach a state with no founders
is not possible.}

\item{timeout}{The maximum time in seconds to spend searching for
the best hint. Default is \code{60} seconds.}
}
\value{
The best Hints object out of all the permutations
}
\description{
When computer time is cheap, use this routine to get a \emph{best}
Pedigree alignment.
This routine will try all possible founder orders, and return the one
with the least \strong{stress}.
}
\details{
The \code{\link[=auto_hint]{auto_hint()}} routine will rearrange sibling order,
but not founder order.
This calls \code{\link[=auto_hint]{auto_hint()}} with every possible founder
order, and finds that plot with the least "stress".
The stress is computed as a weighted sum of three error measures:
\itemize{
\item nbArcs The number of duplicate individuals in the plot
\item lgArcs The sum of the absolute values of the differences in the
positions of duplicate individuals
\item lgParentsChilds The sum of the absolute values of the differences between
the center of the children and the parents
}

\deqn{stress =
    wt[1] * nbArcs +
    wt[2] * lgArcs +
    wt[3] * lgParentsChilds
}

If during the search, a plot is found with a stress level less than
\strong{tolerance}, the search is terminated.
}
\examples{
data(sampleped)
pedi <- Pedigree(sampleped[sampleped$famid == 1,])
best_hint(pedi)
}
\seealso{
\code{\link[=auto_hint]{auto_hint()}}, \code{\link[=align]{align()}}
}
\keyword{alignment,}
\keyword{auto_hint}
