% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alignped1.R
\name{alignped1}
\alias{alignped1}
\title{Alignment first routine}
\usage{
alignped1(idx, dadx, momx, level, horder, packed, spouselist)
}
\arguments{
\item{idx}{Indexes of the subjects}

\item{dadx}{Indexes of the fathers}

\item{momx}{Indexes of the mothers}

\item{level}{Vector of the level of each subject}

\item{horder}{A named numeric vector with one element per subject in the
Pedigree.  It determines the relative horizontal order of subjects within a
sibship, as well as the relative order of processing for the founder couples.
(For this latter, the female founders are ordered as though
they were sisters).
The names of the vector should be the individual identifiers.}

\item{packed}{Should the Pedigree be compressed.
(i.e. allow diagonal lines connecting parents to children in order
to have a smaller overall width for the plot.)}

\item{spouselist}{Matrix of spouses with 4 columns:
\itemize{
\item \code{1}: husband index
\item \code{2}: wife index
\item \code{3}: husband anchor
\item \code{4}: wife anchor
}}
}
\value{
A list containing the elements to plot the Pedigree.
It contains a set of matrices along with the spouselist matrix.
The latter has marriages removed as they are processed.
\itemize{
\item \code{n} : A vector giving the number of subjects on each horizonal
level of the plot
\item \code{nid} : A matrix with one row for each level, giving the numeric
id of each subject plotted.
(A value of \code{17} means the 17th subject in the Pedigree).
\item \code{pos} : A matrix giving the horizontal position of each plot point
\item \code{fam} : A matrix giving the family id of each plot point.
A value of \code{3} would mean that the two subjects in positions
3 and 4, in the row above, are this subject's parents.
\item \code{spouselist} : Spouse matrix with anchors informations
}
}
\description{
First alignment routine which create the subtree founded on a single
subject as though it were the only tree.
}
\details{
In this routine the \strong{nid} array consists of the final
\verb{nid array + 1/2} of the final spouse array.
Note that the \strong{spouselist} matrix will only contain spouse pairs
that are not yet processed. The logic for anchoring is slightly tricky.
\subsection{1. Anchoring:}{

First, if col 4 of the spouselist matrix is 0, we anchor at the first
opportunity. Also note that if \code{spouselist[, 3] == spouselist[, 4]}
it is the husband who is the anchor (just write out the possibilities).
}

\subsection{2. Return values initialization:}{

Create the set of 3 return structures, which will be matrices
with \code{1 + nspouse} columns.
If there are children then other routines will widen the result.
}

\subsection{3. Create \strong{lspouse} and \strong{rspouse}:}{

This two complimentary lists denote the spouses plotted on the left
and on the right.
For someone with lots of spouses we try to split them evenly.
If the number of spouses is odd, then men should have more on
the right than on the left, women more on the right.
Any hints in the spouselist matrix override.
We put the undecided marriages closest to \strong{idx}, then add
predetermined ones to the left and right. The majority of marriages will
be undetermined singletons, for which \strong{nleft} will be \code{1} for
female (put my husband to the left) and \code{0} for male. In one bug found
by plotting canine data, lspouse could initially be empty but
\code{length(rspouse) > 1}. This caused \code{nleft > length(indx)}.
A fix was to not let \strong{indx} to be indexed beyond its length,
fix by JPS 5/2013.
}

\subsection{4. List the children:}{

For each spouse get the list of children. If there are any we
call \code{\link[=alignped2]{alignped2()}} to generate their tree and
then mark the connection to their parent.
If multiple marriages have children we need to join the trees.
}

\subsection{5. Splice the tree:}{

To finish up we need to splice together the tree made up from
all the kids, which only has data from \code{lev + 1} down, with the data here.
There are 3 cases:
\enumerate{
\item No children were found.
\item The tree below is wider than the tree here, in which case we add
the data from this level onto theirs.
\item The tree below is narrower, for instance an only child.
}
}
}
\examples{
data(sampleped)
pedi <- Pedigree(sampleped)
align(pedi)

}
\seealso{
\code{\link[=align]{align()}}
}
\keyword{alignment}
\keyword{internal,}
