% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{findRAfromCount}
\alias{findRAfromCount}
\title{Return the Relative Abundance (RA) data for the given count OTU table}
\usage{
findRAfromCount(count_otu)
}
\arguments{
\item{count_otu}{Count OTU table}
}
\value{
ra_otu Relative Abundance (RA) OTU table
}
\description{
Return the Relative Abundance (RA) data for the given count OTU table
}
\examples{
data_dir <- system.file("data", package = "PathoStat")
infileName <- "pstat_data.rda"
pstat_test <- loadPstat(data_dir, infileName)
ra_otu <- findRAfromCount(phyloseq::otu_table(pstat_test))
}
