% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{pathwaySummary}
\alias{pathwaySummary}
\title{Pathway Summary Statistics}
\usage{
pathwaySummary(
  exprsMat,
  pathwayRef,
  id = "ENSEMBL",
  zNormalize = FALSE,
  method = FALSE,
  deGenes = NULL,
  trim = 0,
  tScores = NULL
)
}
\arguments{
\item{exprsMat}{Gene expression matrix with row names as genes and samples
as columns.}

\item{pathwayRef}{Table of pathway-gene associations. Created from
\code{\link{pathwayGeneTab}} function.}

\item{id}{Gene annotation type in the row name of gene expression data.}

\item{zNormalize}{Normalization of pathway summary score.}

\item{method}{Choice of how to summarize gene ranks into pathway statistics.}

\item{deGenes}{List of differentially expressed genes along with t-scores.
Only necessary if working on Top 50\% summary method.}

\item{trim}{Percentage of top and bottom ranked genes to be excluded from
pathway summary statistics.}

\item{tScores}{Argument for-top-50-percent-genes method.}
}
\value{
pathExp Table of pathway activity profiles per sample.
}
\description{
Generates a table of pathway activity profiles per sample
}
\examples{
pathTab <- tibble::tribble(
 ~Pathway, ~ENTREZID,  ~ENSEMBL,
 "Path1",   "125",      "ENSG00000196616",
 "Path1",   "3099",     "ENSG00000159399",
 "Path2",   "5230",     "ENSG00000102144",
 "Path2",   "5162",     "ENSG00000168291"
 )
exprsMat <- matrix(2 * (seq_len(12)), 4, 3)
rownames(exprsMat) <- pathTab$ENSEMBL
colnames(exprsMat) <- LETTERS[seq_len(3)]
pathwaySummary(exprsMat, pathTab, method = "x2")
}
