% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusterPlotter.R
\name{clusterPlot}
\alias{clusterPlot}
\title{Plots clusters of pathways with associated directionality.}
\usage{
clusterPlot(
  subNet,
  subplot = FALSE,
  topClusters = 2,
  prefix = "",
  outDir = ".",
  plotSave = TRUE
)
}
\arguments{
\item{subNet}{pathways network (edge list of pathways)}

\item{subplot}{if TRUE, store individual clusters plots and connected plots
in Figures directory of plots}

\item{topClusters}{plot figures for top x clusters}

\item{prefix}{add prefix to plots}

\item{outDir}{output directory}

\item{plotSave}{saves the plot if set true. Otherwise display}
}
\value{
a set of plots for DE-PCXN and subclusters
}
\description{
Plots clusters of pathways with associated directionality.
}
\examples{
data(miniTestsPanomiR)
clusterPlot(miniTestsPanomiR$miniPathClusts$DE_PCXN, plotSave = FALSE)
}
