% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DEPlots.R
\name{plot_volcano_DE}
\alias{plot_volcano_DE}
\title{Volcano plots of DE results}
\usage{
plot_volcano_DE(
  de_res,
  ain = NULL,
  comparisons = NULL,
  facet_norm = TRUE,
  facet_comparison = FALSE
)
}
\arguments{
\item{de_res}{data table resulting of run_DE}

\item{ain}{Vector of strings of normalization methods to visualize (must be valid normalization methods saved in de_res)}

\item{comparisons}{Vector of comparisons (must be valid comparisons saved in de_res)}

\item{facet_norm}{Boolean indicating whether to facet by normalization method (TRUE) or not (FALSE)}

\item{facet_comparison}{Boolean indicating whether to facet by comparison (TRUE) or not (FALSE). Only valid if facet_norm = FALSE.}
}
\value{
list of ggplot objects
}
\description{
Volcano plots of DE results
}
\examples{
data(tuberculosis_TMT_de_res)
plot_volcano_DE(tuberculosis_TMT_de_res, ain = NULL,
                comparisons = NULL, facet_norm = TRUE,
                facet_comparison = FALSE)

}
