% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DEIntersection.R
\name{plot_upset_DE}
\alias{plot_upset_DE}
\title{Upset plots of DE results of the different normalization methods}
\usage{
plot_upset_DE(
  de_res,
  ain = NULL,
  comparisons = NULL,
  min_degree = 2,
  plot_type = "single"
)
}
\arguments{
\item{de_res}{data table resulting of run_DE}

\item{ain}{Vector of strings of normalization methods to visualize (must be valid normalization methods saved in de_res)}

\item{comparisons}{Vector of comparisons (must be valid comparisons saved in de_res)}

\item{min_degree}{Minimal degree of an intersection for it to be included}

\item{plot_type}{String indicating whether to plot a single plot per comparison ("single") or stack the number of DE per comparison ("stacked)}
}
\value{
list of plots and intersection tables (split by comparison if plot_type == "single)
}
\description{
Upset plots of DE results of the different normalization methods
}
\examples{
data(tuberculosis_TMT_de_res)
plot_upset_DE(tuberculosis_TMT_de_res,
              ain = c("IRS_on_RobNorm", "IRS_on_Median"),
              comparisons = NULL, min_degree = 2,
              plot_type = "stacked")

}
