% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DEPlots.R
\name{plot_overview_DE_bar}
\alias{plot_overview_DE_bar}
\title{Overview plots of DE results}
\usage{
plot_overview_DE_bar(
  de_res,
  ain = NULL,
  comparisons = NULL,
  plot_type = "single"
)
}
\arguments{
\item{de_res}{data table resulting of run_DE}

\item{ain}{Vector of strings of normalization methods to visualize (must be valid normalization methods saved in de_res)}

\item{comparisons}{Vector of comparisons (must be valid comparisons saved in de_res)}

\item{plot_type}{String indicating whether to plot a single plot per comparison ("single"), facet by comparison ("facet_comp"), stack the number of DE per comparison ("stacked"), or stack the number of DE per comparison but facet by up- and down-regulated ("facet_regulation")}
}
\value{
list of ggplot objects or single object if plot_type = facet or stacked
}
\description{
Overview plots of DE results
}
\examples{
data(tuberculosis_TMT_de_res)
plot_overview_DE_bar(tuberculosis_TMT_de_res, ain = NULL, comparisons = NULL,
                     plot_type = "facet_regulation")

}
