% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DEIntersection.R
\name{plot_jaccard_heatmap}
\alias{plot_jaccard_heatmap}
\title{Jaccard similarity heatmap of DE proteins of the different normalization methods}
\usage{
plot_jaccard_heatmap(
  de_res,
  ain = NULL,
  comparisons = NULL,
  plot_type = "single"
)
}
\arguments{
\item{de_res}{data table resulting of run_DE}

\item{ain}{Vector of strings of normalization methods to visualize (must be valid normalization methods saved in de_res)}

\item{comparisons}{Vector of comparisons (must be valid comparisons saved in de_res)}

\item{plot_type}{String indicating whether to plot a single plot per comparison ("single"), facet by comparison ("facet_comp"), or include all comparisons in a single plot ("all")}
}
\value{
ggplot object (list of objects if plot_type == "single)
}
\description{
Jaccard similarity heatmap of DE proteins of the different normalization methods
}
\examples{
data(tuberculosis_TMT_de_res)
plot_jaccard_heatmap(tuberculosis_TMT_de_res, ain = NULL,
                    comparisons = NULL, plot_type = "all")

}
