% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PomaNorm.R
\name{PomaNorm}
\alias{PomaNorm}
\title{Normalize Data}
\usage{
PomaNorm(data, sample_norm = "none", method = "log_pareto")
}
\arguments{
\item{data}{A \code{SummarizedExperiment} object.}

\item{sample_norm}{Character. Sample normalization method. Options include "none" (default), "sum", or "quantile". Quantile is often used when >100 samples.}

\item{method}{Character. The normalization method to use. Options include "none" (no normalization), "auto_scaling" (autoscaling, i.e., Z-score normalization), "level_scaling" (level scaling), "log_scaling" (log scaling), "log" (log transformation), "vast_scaling" (vast scaling), "log_pareto" (log Pareto scaling), "min_max" (min-max), and "box_cox" (Box-Cox transformation).}
}
\value{
A \code{SummarizedExperiment} object with normalized data.
}
\description{
\code{PomaNorm} performs data normalization using various normalization methods.
}
\examples{
# Output is a normalized SummarizedExperiment object
data <- POMA::st000284 # Example SummarizedExperiment object included in POMA

# No sample normalization
data \%>\% 
  PomaNorm(sample_norm = "none", 
           method = "log_pareto")

# Sum sample normalization
data \%>\% 
  PomaNorm(sample_norm = "sum", 
           method = "log_pareto")
}
\references{
Van den Berg, R. A., Hoefsloot, H. C., Westerhuis, J. A., Smilde, A. K., & van der Werf, M. J. (2006). Centering, scaling, and transformations: improving the biological information content of metabolomics data. BMC genomics, 7(1), 142.
}
\author{
Pol Castellano-Escuder
}
