% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PomaLasso.R
\name{PomaLasso}
\alias{PomaLasso}
\title{Lasso, Ridge, and Elasticnet Regularized Generalized Linear Models for Binary Outcomes}
\usage{
PomaLasso(
  data,
  alpha = 1,
  ntest = NULL,
  nfolds = 10,
  lambda = NULL,
  labels = FALSE
)
}
\arguments{
\item{data}{A \code{SummarizedExperiment} object.}

\item{alpha}{Numeric. Indicates the elasticnet mixing parameter. alpha = 1 is the LASSO penalty and alpha = 0 is the Ridge penalty.}

\item{ntest}{Numeric. Indicates the percentage of observations that will be used as test set. Default is NULL (no test set).}

\item{nfolds}{Numeric. Indicates number of folds for cross-validation (default is 10). Although nfolds can be as large as the sample size (leave-one-out CV), it is not recommended for large datasets. Smallest value allowable is nfolds = 3.}

\item{lambda}{Numeric. Indicates the user supplied lambda sequence. Typical usage is to have the program compute its own lambda sequence based on \code{nlambda} and \code{lambda.min.ratio}. See \code{?glmnet::glmnet()}.}

\item{labels}{Logical. Indicates if feature names should be plotted in coefficient plot or not. Default is FALSE.}
}
\value{
A \code{list} with results.
}
\description{
\code{PomaLasso} performs LASSO, Ridge, and Elasticnet regression for feature selection and prediction purposes for binary outcomes.
}
\examples{
data <- POMA::st000336 \%>\% # Example SummarizedExperiment object included in POMA
  PomaImpute() \%>\% 
  PomaNorm()

## Output is a list with objects `coefficients` (tibble), `coefficients_plot` (ggplot2 object), `cv_plot` (ggplot2 object), and `model` (cv.glmnet object)
# LASSO
data \%>\%
  PomaLasso(alpha = 1,
            ntest = NULL,
            nfolds = 10,
            lambda = NULL,
            labels = TRUE)

# Elasticnet
data \%>\%
  PomaLasso(alpha = 0.5,
            ntest = NULL,
            nfolds = 10,
            lambda = NULL,
            labels = TRUE)

# Ridge Regression
data \%>\%
  PomaLasso(alpha = 0,
            ntest = NULL,
            nfolds = 10,
            lambda = NULL,
            labels = FALSE)
}
\references{
Jerome Friedman, Trevor Hastie, Robert Tibshirani (2010). Regularization Paths for Generalized Linear Models via Coordinate Descent. Journal of Statistical Software, 33(1), 1-22. URL http://www.jstatsoft.org/v33/i01/.
}
\author{
Pol Castellano-Escuder
}
