% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PomaDESeq.R
\name{PomaDESeq}
\alias{PomaDESeq}
\title{Differential Expression Analysis Based on the Negative Binomial Distribution}
\usage{
PomaDESeq(data, contrast = NULL, outcome = NULL, covs = NULL, adjust = "fdr")
}
\arguments{
\item{data}{A \code{SummarizedExperiment} object.}

\item{contrast}{Character. Indicates the comparison. For example, "Group1-Group2" or "control-intervention".}

\item{outcome}{Character. Indicates the name of the \code{colData} column to be used as the outcome factor. Default is NULL (first factor variable in \code{colData}).}

\item{covs}{Character vector. Indicates the names of \code{colData} columns to be included as covariates. Default is NULL (no covariates). If not NULL, a limma model will be fitted using the specified covariates. Note: The order of the covariates is important and should be listed in increasing order of importance in the experimental design.}

\item{adjust}{Character. Indicates the multiple comparisons correction method. Options are: "fdr", "holm", "hochberg", "hommel", "bonferroni", "BH" and "BY".}
}
\value{
A \code{tibble} with the results.
}
\description{
\code{PomaDESeq} estimates variance-mean dependence in count data from high-throughput sequencing assays and test for differential expression based on a model using the negative binomial distribution.
}
\examples{
#library("airway")
#data("airway")
#se <- airway
#
## Classic DESeq2
#DESeq_results <- se \%>\% 
#  PomaDESeq(contrast = NULL,
#            outcome = "dex",
#            covs = NULL,
#            adjust = "fdr")
#
#DESeq_results \%>\% 
#  dplyr::slice(1:10)
#
### Volcano plot
#DESeq_results \%>\% 
#  dplyr::select(feature, log2FC, pvalue) \%>\% 
#  PomaVolcano(labels = TRUE)
#
### Boxplot of top features
#se \%>\% 
#  PomaBoxplots(x = "features", 
#               outcome = "cell", # factorial variable to group by (e.g., treatment, sex, etc)
#               feature_name = DESeq_results$feature[1:10])
#
### Heatmap of top features
#se[rownames(se) \%in\% DESeq_results$feature[1:10]] \%>\% 
#  PomaHeatmap(covs = c("cell", "dex"), # covariates to plot (e.g., treatment, sex, etc)
#              feature_names = TRUE)
#
## DESeq2 with covariates
#DESeq_results <- se \%>\% 
#  PomaDESeq(contrast = NULL,
#            outcome = "dex",
#            covs = "cell",
#            adjust = "fdr")
#
#DESeq_results \%>\% 
#  dplyr::slice(1:10)
#
### Volcano plot
#DESeq_results \%>\% 
#  dplyr::select(feature, log2FC, adj_pvalue) \%>\% 
#  PomaVolcano(labels = TRUE, y_label = "-log10 (Adjusted P-value)")
#
### Boxplot of top features
#se \%>\% 
#  PomaBoxplots(x = "features", 
#               outcome = "dex", # factorial variable to group by (e.g., treatment, sex, etc)
#               feature_name = DESeq_results$feature[1:10])
#
### Heatmap of top features
#se[rownames(se) \%in\% DESeq_results$feature[1:10]] \%>\% 
#  PomaHeatmap(covs = c("cell", "dex"), # covariates to plot (e.g., treatment, sex, etc)
#              feature_names = TRUE)
#
## DESeq2 with covariates and batch
#DESeq_results <- se \%>\% 
#  PomaDESeq(contrast = NULL,
#            outcome = "dex",
#            covs = c("batch", "cell"),
#            adjust = "fdr")
#
#DESeq_results \%>\% 
#  dplyr::slice(1:10)
#
### Volcano plot
#DESeq_results \%>\% 
#  dplyr::select(feature, log2FC, adj_pvalue) \%>\% 
#  PomaVolcano(labels = TRUE, y_label = "-log10 (Adjusted P-value)")
#
### Boxplot of top features
#se \%>\% 
#  PomaBoxplots(x = "features", 
#               outcome = "cell", # factorial variable to group by (e.g., treatment, sex, etc)
#               feature_name = DESeq_results$feature[1:10])
#
### Heatmap of top features
#se[rownames(se) \%in\% DESeq_results$feature[1:10]] \%>\% 
#  PomaHeatmap(covs = c("cell", "dex"), # covariates to plot (e.g., treatment, sex, etc)
#              feature_names = TRUE)
}
\references{
Love, M.I., Huber, W., Anders, S. Moderated estimation of fold change and dispersion for RNA-seq data with DESeq2 Genome Biology 15(12):550 (2014)
}
\author{
Pol Castellano-Escuder
}
