% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrixToSquareHeatmap.R
\name{matrixToSquareHeatmap}
\alias{matrixToSquareHeatmap}
\title{Generate a square heatmap from a matrix}
\usage{
matrixToSquareHeatmap(input, x = NULL, y = NULL)
}
\arguments{
\item{input}{A matrix containing the data to be visualized.}

\item{x}{A character vector specifying the columns to highlight.}

\item{y}{A character vector specifying the rows to highlight.}
}
\value{
A plotly heatmap object with a square layout.
}
\description{
This function generates a heatmap using `plotly`, ensuring the plot has a
square aspect ratio. It highlights user-specified rows and columns.
}
\examples{
# Create a sample matrix
mat <- matrix(c(1, 0, 1, 0), 2, 2)
colnames(mat) <- c("Col1", "Col2")
rownames(mat) <- c("Row1", "Row2")
sq_heatmap <- matrixToSquareHeatmap(input = mat, x = "Col1", y = "Row1")
# To display in an interactive session:
# sq_heatmap
}
