% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plsda_batch.R
\name{deflate_mtx}
\alias{deflate_mtx}
\title{Matrix Deflation}
\usage{
deflate_mtx(X, t)
}
\arguments{
\item{X}{A numeric matrix to be deflated. It assumes that samples are
on the row, while variables are on the column. \code{NA}s are not allowed.}

\item{t}{A component to be deflated out from the matrix.}
}
\value{
A deflated matrix with the same dimension as the input matrix.
}
\description{
This function removes the variance of given component \code{t} from the
input matrix \code{X}. \deqn{\hat{X} = X - t (t^{\top}t)^{-1}t^{\top}X}
It is a built-in function of \code{PLSDA_batch}.
}
\examples{
# A built-in function of PLSDA_batch, not separately used.
# Not run
data('AD_data')
library(mixOmics)
library(TreeSummarizedExperiment)

X <- assays(AD_data$EgData)$Clr_value
ad_pca <- pca(X, ncomp = 3)
# the matrix without the information of PC1:
ad.def.mtx <- deflate_mtx(X, ad_pca$variates$X[ ,1])


}
\references{
\insertRef{barker2003partial}{PLSDAbatch}
}
\author{
Yiwen Wang, Kim-Anh Lê Cao
}
\keyword{Internal}
