% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PICBstrandanalysis.R
\name{PICBstrandanalysis}
\alias{PICBstrandanalysis}
\title{Add sense/antisense ratio of unique piRNAs per piRNA cluster}
\usage{
PICBstrandanalysis(IN.ALIGNMENTS, IN.RANGES, VERBOSE = TRUE)
}
\arguments{
\item{IN.ALIGNMENTS}{list of alignments from PICBload}

\item{IN.RANGES}{single GRanges object (seeds, cores or clusters from PICBbuild)}

\item{VERBOSE}{enables progress output. True by default.}
}
\value{
GRanges object with an additional annotation column
}
\description{
Add sense/antisense ratio of unique piRNAs per piRNA cluster
}
\examples{
library(BSgenome.Dmelanogaster.UCSC.dm6)
myAlignmentsFromPICBload <- PICBload(
    BAMFILE = system.file("extdata", "Fly_Ov1_chr2L_20To21mb_filtered.bam", package = "PICB"),
    REFERENCE.GENOME = "BSgenome.Dmelanogaster.UCSC.dm6",
    VERBOSE = FALSE
)

outputOfPICBbuild <- PICBbuild(
    IN.ALIGNMENTS = myAlignmentsFromPICBload,
    REFERENCE.GENOME = "BSgenome.Dmelanogaster.UCSC.dm6",
    VERBOSITY = 0
)

outputOfPICBbuild$clusters <- PICBstrandanalysis(
    IN.ALIGNMENTS = myAlignmentsFromPICBload,
    IN.RANGES = outputOfPICBbuild$clusters
)
}
\author{
Parthena Konstantinidou

Zuzana Loubalova

Franziska Ahrend
}
