% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PICBload.R
\name{PICBload}
\alias{PICBload}
\title{Load and preprocess BAM files containing piRNA alignments}
\usage{
PICBload(
  BAMFILE = NULL,
  REFERENCE.GENOME = NULL,
  SIMPLE.CIGAR = TRUE,
  IS.SECONDARY.ALIGNMENT = NA,
  STANDARD.CONTIGS.ONLY = TRUE,
  PERFECT.MATCH.ONLY = FALSE,
  FILTER.BY.FLAG = TRUE,
  SELECT.FLAG = c(0, 16, 272, 256),
  USE.SIZE.FILTER = TRUE,
  READ.SIZE.RANGE = c(18, 50),
  TAGS = c("NH", "NM"),
  WHAT = c("flag"),
  SEQ.LEVELS.STYLE = "UCSC",
  GET.ORIGINAL.SEQUENCE = FALSE,
  VERBOSE = TRUE
)
}
\arguments{
\item{BAMFILE}{name of the bam file to load. Should be sorted and indexed.}

\item{REFERENCE.GENOME}{name of genome. For example "BSgenome.Dmelanogaster.UCSC.dm6"}

\item{SIMPLE.CIGAR}{simpleCigar parameter of Rsamtools::ScanBamParam}

\item{IS.SECONDARY.ALIGNMENT}{defines loading of primary/secondary alignments. Default value NA loads both primary and secondary.}

\item{STANDARD.CONTIGS.ONLY}{use only standard chromosomes}

\item{PERFECT.MATCH.ONLY}{load only alignments without mismatches}

\item{FILTER.BY.FLAG}{enables filtering by flag. TRUE by default.}

\item{SELECT.FLAG}{vector of flags to use. Default value c(0,16, 272, 256).}

\item{USE.SIZE.FILTER}{enables filter by alignment size. True by default.}

\item{READ.SIZE.RANGE}{allowed alignment sizes. c(18,50) by default.}

\item{TAGS}{tags to import from bam file. c("NH","NM") by default.}

\item{WHAT}{"what" parameter of Rsamtools::ScanBamParam. c("flag") by default.}

\item{SEQ.LEVELS.STYLE}{naming of chromosomes style. "UCSC" by default.}

\item{GET.ORIGINAL.SEQUENCE}{adds "seq" to WHAT. False by default.}

\item{VERBOSE}{enables progress output. True by default.}
}
\value{
list of GRanges objects named "unique" for unique mapping alignments,
"multi.primary" for primary multimapping alignments,
"multi.secondary" for secondary multimapping alignments
}
\description{
Load and preprocess BAM files containing piRNA alignments
}
\examples{
library(BSgenome.Dmelanogaster.UCSC.dm6)
PICBload(
    BAMFILE = system.file("extdata", "Fly_Ov1_chr2L_20To21mb_filtered.bam", package = "PICB"),
    REFERENCE.GENOME = "BSgenome.Dmelanogaster.UCSC.dm6",
    VERBOSE = FALSE
)

}
\author{
Pavol Genzor

Daniel Stoyko

Aleksandr Friman

Franziska Ahrend
}
