% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PICBannotate.R
\name{PICBannotate}
\alias{PICBannotate}
\title{Annotate GRanges according to a piRNA library}
\usage{
PICBannotate(
  INPUT.GRANGES,
  ALIGNMENTS,
  REFERENCE.GENOME = NULL,
  REPLICATE.NAME = NULL,
  LIBRARY.SIZE = length(ALIGNMENTS$unique) + length(ALIGNMENTS$multi.primary),
  PROVIDE.NON.NORMALIZED = FALSE,
  SEQ.LEVELS.STYLE = "UCSC",
  COMPUTE.1U.10A.FRACTIONS = FALSE
)
}
\arguments{
\item{INPUT.GRANGES}{GRanges (seeds/cores/clusters) to annotate}

\item{ALIGNMENTS}{list of alignments from PICBload}

\item{REFERENCE.GENOME}{name of genome. For example "BSgenome.Dmelanogaster.UCSC.dm6"}

\item{REPLICATE.NAME}{name of the replicate. NULL by default.}

\item{LIBRARY.SIZE}{number of reads in the library. By default computed as number of unique mapping alignments + number of primary multimapping alignments.}

\item{PROVIDE.NON.NORMALIZED}{provide annotations in non-normalized format. False by default.}

\item{SEQ.LEVELS.STYLE}{naming of chromosomes style. "UCSC" by default.}

\item{COMPUTE.1U.10A.FRACTIONS}{for each locus and each alignments type (unique mapping, primary multimapping, secodnary multimapping) compute fraction 1U and 10A containing reads overlapping the locus. Default FALSE.}
}
\value{
GRanges object with extra annotation columns
}
\description{
Annotate GRanges according to a piRNA library
}
\examples{
library(BSgenome.Dmelanogaster.UCSC.dm6)
myGenome <- "BSgenome.Dmelanogaster.UCSC.dm6"
myAlignmentsFromPICBload <- PICBload(
    BAMFILE = system.file("extdata", "Fly_Ov1_chr2L_20To21mb_filtered.bam", package = "PICB"),
    REFERENCE.GENOME = myGenome,
    VERBOSE = FALSE
)
myRangesFromPICBbuild <- PICBbuild(
    IN.ALIGNMENTS = myAlignmentsFromPICBload,
    REFERENCE.GENOME = myGenome,
    VERBOSITY = 0
)

myClustersFromPICBbuildAnnotationsRemoved <- GenomicRanges::granges(myRangesFromPICBbuild$clusters)

PICBannotate(
    INPUT.GRANGES = myClustersFromPICBbuildAnnotationsRemoved,
    ALIGNMENTS = myAlignmentsFromPICBload,
    REFERENCE.GENOME = myGenome,
    PROVIDE.NON.NORMALIZED = TRUE
)
}
\author{
Aleksandr Friman
}
