% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-trainModel.R
\name{trainModel}
\alias{trainModel}
\title{Train a Model Based on the Data in an S4 Object}
\usage{
trainModel(object, ...)
}
\arguments{
\item{object}{An \code{S4} object representing an untrained statistical or machine.
learning model.}

\item{...}{Allow new method to be defined for this generic.}
}
\value{
The same object with the @model slot populated with the fit model
}
\description{
Train a Model Based on the Data in an S4 Object
}
\examples{
data(samplePCOSPmodel)
set.seed(getModelSeed(samplePCOSPmodel))

# Set parallelization settings
BiocParallel::register(BiocParallel::SerialParam())

trainModel(samplePCOSPmodel, numModels=5, minAccuracy=0.6)

}
