% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{renameColumns}
\alias{renameColumns}
\title{Rename columns or do nothing if the names don't match}
\usage{
renameColumns(x, values)
}
\arguments{
\item{x}{An object for which \code{colnames} is defined, probably a \code{data.frame}
or other similar object.}

\item{values}{A character vector where names are the old column names
and values are the new column names. Uses \code{gsub} internally to do
the renaming.}
}
\value{
\code{x} with the updated column names if they are present. Does not
fail if the column names are missing.
}
\description{
Rename columns or do nothing if the names don't match
}
\examples{
x <- data.frame(a=factor(LETTERS[1:5]), b=factor(runif(5, 0, 1)))
renameColumns(x, c(a='c'))

}
