% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-predictClasses.R
\name{predictClasses,CohortList,PCOSP_or_RLS_or_RGA-method}
\alias{predictClasses,CohortList,PCOSP_or_RLS_or_RGA-method}
\title{Predict Survival Prognosis Classes and Risk Scores for A \code{CohortList} Using
a \code{PCOSP}, \code{RLSModel} or \code{RGAModel} object.}
\usage{
\S4method{predictClasses}{CohortList,PCOSP_or_RLS_or_RGA}(object, model, ...)
}
\arguments{
\item{object}{A \code{CohortList} with \code{SurvivalExperiment}s to predict classes
for.}

\item{model}{A trained \code{PCOSP} model to use for predicting classes.}

\item{...}{Fall through arguments to \code{BiocParallel::bplapply} for configuring
parallelization settings.}
}
\value{
A \code{CohortList} with the model predictions attached to each
\code{SurvivalExperiment} in the metadata slot and the \code{prob_good_survival}
column added to the colData slot.
}
\description{
Predict Survival Prognosis Classes and Risk Scores for A \code{CohortList} Using
a \code{PCOSP}, \code{RLSModel} or \code{RGAModel} object.
}
\examples{
data(sampleTrainedPCOSPmodel)
data(sampleCohortList)

# Set parallelization settings
BiocParallel::register(BiocParallel::SerialParam())

# Make predictions
PCOSPpredCohortList <- predictClasses(sampleCohortList[seq_len(2)],
  model=sampleTrainedPCOSPmodel)
head(colData(PCOSPpredCohortList[[1]]))

}
