% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-predictClasses.R
\name{predictClasses,CohortList,ClinicalModel-method}
\alias{predictClasses,CohortList,ClinicalModel-method}
\title{Use a Clinical GLM to Predict Classes for a \code{CohortList} of
\code{SurvivalExperment} Objects.}
\usage{
\S4method{predictClasses}{CohortList,ClinicalModel}(object, model, ..., na.action = "na.exclude", type = "response")
}
\arguments{
\item{object}{A \code{CohortList} with \code{SurvivalExperiment}s to predict classes
for. The colData slot in ALL \code{SurvivalExperiment}s must have column names
which match the formula in the model object.}

\item{model}{A trained \code{ClinicalModel} object, as return by \code{trainModel}.}

\item{...}{Fall through parameters to \code{\link[stats:predict]{stats::predict}}.}

\item{na.action}{The \code{na.action} paramter passed to \code{\link[stats:predict.glm]{stats::predict.glm}}.}

\item{type}{The \code{type} parameter passed to \code{\link[stats:predict.glm]{stats::predict.glm}}}
}
\value{
A \code{CohortList} with the model predictions in the colData
slot as clinical_prob_good for each \code{SurvivalExperiment}, and the
model in the metadata as predictionModel.
}
\description{
Use a Clinical GLM to Predict Classes for a \code{CohortList} of
\code{SurvivalExperment} Objects.
}
\examples{
data(sampleClinicalModel)
data(sampleCohortList)

# Set parallelization settings
BiocParallel::register(BiocParallel::SerialParam())

# Train Model
trainedClinicalModel <- trainModel(sampleClinicalModel)

# Make predictions
ClinicalPredCohortList <- predictClasses(sampleCohortList[c('PCSI', 'TCGA')],
  model=trainedClinicalModel)
head(colData(ClinicalPredCohortList[[1]]))

}
