% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-plotROC.R
\name{plotROC,PCOSP-method}
\alias{plotROC,PCOSP-method}
\title{Plot ROC curves for a \code{PCOSP} model object.}
\usage{
\S4method{plotROC}{PCOSP}(object, alpha = 0.05, ..., xlabel, ylabel, title)
}
\arguments{
\item{object}{A \code{PCOSP} model which has been validated with with the
\code{validateModel} method.}

\item{alpha}{A \code{float} specifying the significance level for the plot. Non-
signficiant cohorts will have dotted lines.}

\item{...}{Catch unnamed parameters. Not used.}

\item{xlabel}{A \code{character} vector specifying the x label.}

\item{ylabel}{A \code{character} vector specifying the y label.}

\item{title}{A \code{character} vector speciyfing the plot tile.}
}
\value{
A \code{ggplot} object containing the ROC curves.
}
\description{
Plot ROC curves for a \code{PCOSP} model object.
}
\examples{
data(sampleValPCOSPmodel)

# Plot ROC curves
AUROCplot <- plotROC(sampleValPCOSPmodel)

}
