% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-densityPlotModelComparison.R
\name{densityPlotModelComparison,PCOSP_or_RLS_or_RGA,PCOSP_or_RLS_or_RGA-method}
\alias{densityPlotModelComparison,PCOSP_or_RLS_or_RGA,PCOSP_or_RLS_or_RGA-method}
\title{Render a Density Plot Comparing Model Performance Between Two \code{PCOSP},
\code{RLSModel} or \code{RGAModel} object.}
\usage{
\S4method{densityPlotModelComparison}{PCOSP_or_RLS_or_RGA,PCOSP_or_RLS_or_RGA}(
  object,
  refModel,
  ...,
  title,
  xlab,
  ylab,
  mDataTypeLabels
)
}
\arguments{
\item{object}{A \code{PCOSP}, \code{RLSModel} or \code{RGAModel} object.}

\item{refModel}{A \code{PCOSP}, \code{RLSModel} or \code{RGAModel} object to compare
performance against.}

\item{...}{Catch unnamed parameters. Not used.}

\item{title}{Optional \code{character} vector with plot title.}

\item{xlab}{Optional \code{character} vector with x-axis label.}

\item{ylab}{Optional \code{character} vector with y-axis label.}

\item{mDataTypeLabels}{Optional \code{character} vector whos names are one
or more existing mDataTypes in \code{object} and \code{refModel} and whos values
are the desired mDataType labels in the plot facets.}
}
\value{
A \code{ggplot} object with a density plot of model AUCs for \code{object}
and a vertical line for the average AUC of \code{refModel}, faceted by
mDataType.
}
\description{
Render a Density Plot Comparing Model Performance Between Two \code{PCOSP},
\code{RLSModel} or \code{RGAModel} object.
}
