% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-barPlotModelComparison.R
\name{barPlotModelComparison,ClinicalModel,PCOSP_or_RLS_or_RGA-method}
\alias{barPlotModelComparison,ClinicalModel,PCOSP_or_RLS_or_RGA-method}
\title{Make a Bar Plot Comparison Model Performance Between a ClinicalModel
and a PCOSP, RLSModel or RGAModel object.}
\usage{
\S4method{barPlotModelComparison}{ClinicalModel,PCOSP_or_RLS_or_RGA}(model1, model2, stat, ...)
}
\arguments{
\item{model1}{A \code{ClinicalModel} object.}

\item{model2}{A \code{PCOSP} or \code{RLSModel} or \code{RGAModel} object.}

\item{stat}{A \code{character} vector specifying which statistic to compare the
models using. Options are 'AUC', 'log_D_index' or 'concordance_index'.}

\item{...}{Not used.}
}
\value{
A \code{ggplot2} object showing a barplot coloured by the model and
comparing the stat between all cohorts that both models were validated
with.
}
\description{
Make a Bar Plot Comparison Model Performance Between a ClinicalModel
and a PCOSP, RLSModel or RGAModel object.
}
\examples{
data(sampleValPCOSPmodel)
data(sampleCohortList)
data(sampleICGCmicro)

# Set parallelization settings
BiocParallel::register(BiocParallel::SerialParam())

# Setup the models
clinicalModel <- ClinicalModel(sampleICGCmicro,
  formula='prognosis ~ sex + age + T + N + M + grade',
  randomSeed=1987)

# Train the models
trainedClinicalModel <- trainModel(clinicalModel)

# Make predctions
clinicalPredCohortList <- predictClasses(sampleCohortList[c('PCSI', 'TCGA')],
  model=trainedClinicalModel)

# Validate the models
validatedClinicalModel <- validateModel(trainedClinicalModel,
  valData=clinicalPredCohortList)

# Plot the comparison
modelCompBarPlot <- barPlotModelComparison(validatedClinicalModel,
 sampleValPCOSPmodel, stat='AUC')

}
